#include <vcl.h>
#pragma hdrstop

#include "DLLVersion.h"

#include <shlwapi.h>


DWORD GetDLLVersion(String dllName)
   {
   DWORD version = 0;

   HINSTANCE hInst = LoadLibrary(dllName.c_str());

   if (hInst)
      {
      DLLGETVERSIONPROC getVersion = (DLLGETVERSIONPROC)GetProcAddress(hInst, "DllGetVersion");

      if (getVersion)
         {
         DLLVERSIONINFO info;
         ZeroMemory(&info, sizeof(info));
         info.cbSize = sizeof(info);

         HRESULT result = (*getVersion)(&info);
         if (SUCCEEDED(result))
            version = PackDLLVersion(info.dwMajorVersion, info.dwMinorVersion);
         }

      FreeLibrary(hInst);
      }

   return(version);
   }

